CREATE TABLE `idx_bad_link` (
  `bad_link_id` mediumint(9) unsigned NOT NULL auto_increment,
  `link_id` mediumint(9) unsigned NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `email` varchar(50) NOT NULL default '',
  `type` tinyint(3) unsigned NOT NULL default '0',
  `date` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`bad_link_id`)
);



CREATE TABLE `idx_category` (
  `category_id` mediumint(9) unsigned NOT NULL auto_increment,
  `parent_id` mediumint(9) unsigned NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `description` text NOT NULL,
  `image` varchar(100) default NULL,
  `content` text,
  `visible` char(1) default NULL,
  `links` mediumint(9) default NULL,
  `meta_keyword` text,
  `meta_description` text,
  `permission` char(2) default NULL,
  `registered_only` char(1) default NULL,
  `header` text NOT NULL,
  `footer` text NOT NULL,
  `related` mediumint(6) NOT NULL default '0',
  `page_title` varchar(200) NOT NULL default '',
  `hits` int(11) NOT NULL default '0',
  `order_num` smallint(6) NOT NULL default '0',
  `basic_price` double unsigned NOT NULL default 0,
  `premium_price` double unsigned NOT NULL default 0,
  `sponsored_price` double unsigned NOT NULL default 0,
  PRIMARY KEY  (`category_id`)
);



CREATE TABLE `idx_category_path` (
  `category_id` mediumint(9) NOT NULL default '0',
  `path` text,
  `path_with_url` text,
  `parents` text,
  PRIMARY KEY  (`category_id`)
);



CREATE TABLE `idx_checkurl` (
  `link_id` mediumint(9) NOT NULL default '0',
  `date` date NOT NULL default '0000-00-00',
  `live` char(1) NOT NULL default '',
  `reciprocal_found` char(1) NOT NULL default '',
  PRIMARY KEY  (`link_id`)
);



CREATE TABLE `idx_editor` (
  `username` varchar(20) default NULL,
  `category_id` mediumint(9) default NULL,
  `category` char(1) default NULL,
  `link` char(1) default NULL,
  `review` char(1) default NULL,
  `pick` char(1) default NULL,
  `status` char(1) default NULL,
  `date` date default NULL
);



CREATE TABLE `idx_favorites` (
  `favorite_id` int(11) NOT NULL auto_increment,
  `username` varchar(20) default NULL,
  `date` date default NULL,
  `title` varchar(100) default NULL,
  `description` text,
  PRIMARY KEY  (`favorite_id`)
);



CREATE TABLE `idx_favorites_detail` (
  `favorite_id` int(11) default NULL,
  `link_id` mediumint(9) default NULL
);



CREATE TABLE `idx_invoice` (
  `invoice_id` varchar(10) NOT NULL default '',
  `invoice_date` date default NULL,
  `due_date` date default NULL,
  `invoiced_to` text,
  `service` varchar(255) default NULL,
  `description` text,
  `total` double(8,2) default NULL,
  `comment` text,
  `paid` char(1) default NULL,
  `paid_date` date default NULL,
  `email` varchar(255) default NULL,
  PRIMARY KEY  (`invoice_id`)
);



CREATE TABLE `idx_invoice_config` (
  `company` varchar(255) default NULL,
  `contact` varchar(255) default NULL,
  `address` text,
  `phone` varchar(255) default NULL,
  `email` varchar(255) default NULL,
  `currency_symbol` varchar(255) default '$',
  `currency_code` varchar(255) default 'USD'
);



CREATE TABLE `idx_link` (
  `link_id` mediumint(9) unsigned NOT NULL auto_increment,
  `category_id` mediumint(9) unsigned NOT NULL default '0',
  `title` varchar(100) NOT NULL default '',
  `url` text NOT NULL,
  `description` text NOT NULL,
  `contact_name` varchar(100) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  `hits` mediumint(9) default NULL,
  `votes` smallint(6) NOT NULL default '0',
  `rating` float(4,2) NOT NULL default '0.00',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `bid` smallint(6) NOT NULL default '0',
  `new` char(1) default NULL,
  `hot` char(1) default NULL,
  `top_rated` char(1) default NULL,
  `pick` char(1) default NULL,
  `password` varchar(20) default NULL,
  `updated` char(1) default NULL,
  `reviews` smallint(6) default NULL,
  `avg_review` float(4,2) default NULL,
  `last_updated` datetime default NULL,
  `official_review` text,
  `keywords` varchar(255) default NULL,
  `cat1` mediumint(6) NOT NULL default '0',
  `cat2` mediumint(6) NOT NULL default '0',
  `suspended` char(1) NOT NULL default '0',
  `reciprocal_url` varchar(255) default NULL,
  PRIMARY KEY  (`link_id`)
);



CREATE TABLE `idx_link_temp` (
  `vid` mediumint(9) unsigned NOT NULL auto_increment,
  `link_id` mediumint(9) default NULL,
  `category_id` mediumint(9) unsigned NOT NULL default '0',
  `title` varchar(100) NOT NULL default '',
  `url` text NOT NULL,
  `description` text NOT NULL,
  `contact_name` varchar(100) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  `hits` mediumint(9) default NULL,
  `votes` smallint(6) default NULL,
  `rating` float(4,2) default NULL,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `bid` smallint(6) NOT NULL default '0',
  `new` char(1) default NULL,
  `hot` char(1) default NULL,
  `top_rated` char(1) default NULL,
  `pick` char(1) default NULL,
  `password` varchar(20) default NULL,
  `updated` char(1) default NULL,
  `reviews` smallint(6) default NULL,
  `avg_review` float(4,2) default NULL,
  `last_updated` datetime default NULL,
  `official_review` text,
  `keywords` varchar(255) default NULL,
  `cat1` mediumint(6) NOT NULL default '0',
  `cat2` mediumint(6) NOT NULL default '0',
  `suspended` char(1) NOT NULL default '0',
  `reciprocal_url` varchar(255) default NULL,
  PRIMARY KEY  (`vid`)
);



CREATE TABLE `idx_link_temp_user` (
  `vid` mediumint(9) unsigned NOT NULL default '0',
  `username` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`vid`)
);



CREATE TABLE `idx_link_user` (
  `link_id` mediumint(9) unsigned NOT NULL default '0',
  `username` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`link_id`)
);



CREATE TABLE `idx_mailing_list` (
  `email` varchar(50) NOT NULL default '',
  `code` varchar(4) default NULL,
  `status` char(1) default NULL,
  PRIMARY KEY  (`email`)
);



CREATE TABLE `idx_message` (
  `message_id` smallint(6) NOT NULL auto_increment,
  `date` date default NULL,
  `body` text,
  `subject` varchar(100) default NULL,
  PRIMARY KEY  (`message_id`)
);



CREATE TABLE `idx_notification` (
  `username` varchar(20) NOT NULL default '',
  `category_id` mediumint(9) NOT NULL default '0'
);



CREATE TABLE `idx_paid_listing` (
  `link_id` mediumint(9) unsigned NOT NULL default '0',
  `premium` char(1) default NULL,
  `sponsored` char(1) default NULL,
  `expire` datetime default NULL,
  `paid` char(1) default NULL,
  PRIMARY KEY  (`link_id`)
);



CREATE TABLE `idx_payment_history` (
  `payment_id` int(10) unsigned NOT NULL auto_increment,
  `username` varchar(255) default NULL,
  `type` varchar(255) default NULL,
  `detail` text,
  `amount` double default NULL,
  `time` datetime default NULL,
  PRIMARY KEY  (`payment_id`)
);



CREATE TABLE `idx_review` (
  `review_id` mediumint(9) unsigned NOT NULL auto_increment,
  `link_id` mediumint(9) unsigned NOT NULL default '0',
  `review` text NOT NULL,
  `rating` tinyint(3) unsigned NOT NULL default '0',
  `date` date NOT NULL default '0000-00-00',
  `subject` varchar(100) default NULL,
  `status` char(1) default NULL,
  `username` varchar(20) default NULL,
  `name` varchar(20) default NULL,
  `email` varchar(100) default NULL,
  PRIMARY KEY  (`review_id`)
);



CREATE TABLE `idx_searchlog` (
  `keyword` varchar(100) NOT NULL default '',
  `time` datetime NOT NULL default '0000-00-00 00:00:00',
  `result` mediumint(9) unsigned default NULL,
  `ip` varchar(100) default NULL
);



CREATE TABLE `idx_sessions` (
  `SESSKEY` varchar(32) NOT NULL default '',
  `EXPIRY` int(11) unsigned NOT NULL default '0',
  `EXPIREREF` varchar(64) default NULL,
  `DATA` text NOT NULL,
  PRIMARY KEY  (`SESSKEY`)
);



CREATE TABLE `idx_users` (
  `username` varchar(20) NOT NULL default '',
  `password` varchar(20) default NULL,
  `name` varchar(50) default NULL,
  `email` varchar(50) default NULL,
  `date` date default NULL,
  `status` char(1) default NULL,
  `vcode` varchar(4) default NULL,
  `group_id` tinyint(4) default NULL,
  `homepage` varchar(100) default NULL,
  `icq` varchar(20) default NULL,
  `aol` varchar(20) default NULL,
  `yahoo` varchar(20) default NULL,
  `biography` text,
  `location` varchar(50) default NULL,
  `interest` varchar(50) default NULL,
  `occupation` varchar(50) default NULL,
  PRIMARY KEY  (`username`)
);



CREATE TABLE `idx_votes` (
  `link_id` mediumint(9) NOT NULL default '0',
  `ip` varchar(100) default NULL,
  `value` tinyint(4) default NULL
);



CREATE TABLE `idx_pagerank` (
  `link_id` mediumint(8) unsigned NOT NULL default '0',
  `engine` char(1) NOT NULL default '',
  `rank` tinyint(4) NOT NULL default '0',
  `last_update` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`link_id`,`engine`)
);


CREATE TABLE `idx_custom_field` (
  `field_name` varchar(32) NOT NULL default '',
  `field_text` varchar(64) NOT NULL default '',
  `field_type` enum('TEXT','TEXTAREA','SELECT','MULTISELECT','CHECKBOX','RADIO','FILE','IMAGE','DATE','DATETIME') NOT NULL default 'TEXT',
  `field_option` text NOT NULL,
  `field_img_width` INT(10) unsigned NOT NULL default '0',
  `field_img_height` INT(10) unsigned NOT NULL default '0',
  `field_file_size` INT(10) unsigned NOT NULL default '0',
  `field_file_extension` varchar(64) NOT NULL default '',
  `required` char(1) NOT NULL default '0',
  `searchable` char(1) NOT NULL default '1',
  `permission` char(1) NOT NULL default '0'
);


insert into `idx_users`
    (username, password, name, email, date, status, vcode, group_id, homepage, icq, aol, yahoo, biography, location, interest, occupation) values
    ('admin', 'admin', 'Administrator', '', now(), 1, '', 0, '', '', '', '', '', '', '', '');

insert into `idx_invoice_config`
    (company, contact, address, phone, email, currency_symbol, currency_code) values
    ('Your website / Company', 'Billing Department', 'Your address', 'Your phone #', 'Billing<name@yourdomain.com>', '$', 'USD');

